package client;

import java.util.List;

import common.IModel;
import common.IView;

public class Presenter {

	private static final String[] SEARCH_OPTIONS = new String[] { "A only",
			"B only", "- ALL -" };
	private static final String[] SEARCH_CODES = new String[] { "A", "B", "" };

	private final IView view;
	private final IModel search;

	public Presenter(IView view, IModel search) {
		this.view = view;
		this.search = search;
	}

	public void displayViewOnScreen() {
		view.initalizeAndDisplayView(this);
	}

	public String[] getSearchOptionSelectionStrings() {
		return SEARCH_OPTIONS;
	}

	public void searchButtonPressed() {
		try {
			int selectedSearchIndex = view.getSelectedSearchIndex();
			String searchCode = SEARCH_CODES[selectedSearchIndex];
			List<String> searchResult = search.performSearch(searchCode);
			view.setDisplayText(searchResult.toString());
		} catch (RuntimeException runtimeException) {
			view.setDisplayText(runtimeException.getClass().getName());
		}
	}
}
